local grass_table = { --name, desc, texture, ingredient
   {'grass', 'Grass', 'grass', 'default:grass_1', 'grass'},
   {'rainforest_litter', 'Rainforest Litter', 'rainforest_litter', 'default:junglegrass', 'rainforest_litter'},
   {'dry_grass', 'Savanna Grass', 'dry_grass', 'default:dry_grass_1', 'dry_grass'},
   {'coniferous_litter', 'Coniferous Litter', 'coniferous_litter', 'default:pine_needles', 'coniferous_litter'}
}

for k in pairs (grass_table) do

   local name = grass_table[k][1]
   local desc = grass_table[k][2]
   local texture = grass_table[k][3]
   local ingredient = grass_table[k][4]
   local output_node = grass_table[k][5]

   core.register_node('grass:'..name, {
      description = 'all faces '..desc,
      tiles = {'default_'..texture..'.png'},
      groups = {crumbly = 3, soil = 1},
      drop = 'default:dirt'
   })

   core.register_craft({
      output = 'grass:'..name,
      recipe = {
         {'', ingredient, ''},
         {ingredient, 'default:dirt', ingredient},
         {'', ingredient, ''}
      }
   })

   core.register_craft({
      output = 'default:dirt_with_'..output_node,
      recipe = {
         {'default:dirt', ingredient},
      }
   })
end
